/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityGaladhrimElf;
import lotr.common.entity.npc.LOTREntityGaladhrimWarrior;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTravellingTrader;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LOTREntityGaladhrimTrader
extends LOTREntityGaladhrimElf
implements LOTRTravellingTrader {
    public LOTREntityGaladhrimTrader(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.6, false));
        this.addTargetTasks(false);
        this.npcCape = LOTRCapes.ALIGNMENT_GALADHRIM.capeTexture;
        this.spawnRidingHorse = this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityHorse horse = (LOTREntityHorse)super.createMountToRide();
        horse.setMountArmor(null);
        return horse;
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.GALADHRIM_TRADER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.GALADHRIM_TRADER_SELL;
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return new LOTREntityGaladhrimWarrior(this.field_70170_p);
    }

    @Override
    public String getDepartureSpeech() {
        return "galadhrim/trader/departure";
    }

    public int func_70658_aO() {
        return 10;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.travellingTraderInfo.timeUntilDespawn == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 5 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (damagesource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)damagesource.func_76346_g();
            player.func_70690_d(new PotionEffect(LOTRPotions.curse.field_76415_H, 24000, 0));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)15);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            for (int i = 0; i < 16; ++i) {
                double d = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d3 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                double d4 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                double d5 = -0.2 + (double)(this.field_70146_Z.nextFloat() * 0.4f);
                LOTRMod.proxy.spawnParticle("leafGold_" + (30 + this.field_70146_Z.nextInt(30)), d, d1, d2, d3, d4, d5);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 75.0f && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeElvenTrader);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public boolean shouldRenderNPCHair() {
        return false;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "galadhrim/trader/friendly";
            }
            return "galadhrim/trader/neutral";
        }
        return "galadhrim/trader/hostile";
    }
}

